/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.lang.reflect.Array;

public final class VWIndexDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7479L;
    protected String name;
    protected String[] fieldNames;
    protected boolean systemIndex = false;
    protected boolean mandatorySystemIndex = false;
    protected boolean bHasChanged = false;
    protected VWTableDefinition tableDefinition = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:22:34 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    protected VWIndexDefinition(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition, VWSession theSession) throws VWException {
        this.init(theName, theFields, isSystemIndex, theTableDefinition, false, theSession);
    }

    protected VWIndexDefinition(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition) throws VWException {
        this.init(theName, theFields, isSystemIndex, theTableDefinition, false);
    }

    protected VWIndexDefinition(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition, boolean internal) throws VWException {
        this.init(theName, theFields, isSystemIndex, theTableDefinition, internal);
    }

    protected VWIndexDefinition(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition, boolean internal, VWSession theSession) throws VWException {
        this.init(theName, theFields, isSystemIndex, theTableDefinition, internal, theSession);
    }

    protected void init(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition, boolean internal) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWIndexDefBadName", "Index names cannot be null or empty.");
        }
        if (isSystemIndex) {
            if (!VWFieldType.isValidName(theName, false)) {
                throw new VWException("vw.api.VWIndexDefinitionInvalidSystemIndexName", "Syntax error in system index name {0}, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name begining with F_, or be a language keyword such as ''if'').", theName, 128);
            }
        } else if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWIndexDefinitionInvalidIndexName", "Syntax error in index name {0}, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name begining with F_, or be a language keyword such as ''if'').", theName, 128);
        }
        if (theFields == null || theFields[0] == null) {
            throw new VWException("vw.api.VWIndexDefFieldsAreNull", "Index fields cannot be null or empty.  The first field name must be a valid exposed field name.");
        }
        this.name = theName;
        this.tableDefinition = theTableDefinition;
        this.bHasChanged = true;
        if (internal) {
            this.internalSetFieldNames(theFields);
        } else {
            this.setFieldNames(theFields);
        }
        this.systemIndex = isSystemIndex;
        if (theName.startsWith("F_") && theName.compareTo("F_WorkFlowNumber") != 0) {
            this.mandatorySystemIndex = true;
        }
        this.bHasChanged = false;
    }

    protected void init(String theName, String[] theFields, boolean isSystemIndex, VWTableDefinition theTableDefinition, boolean internal, VWSession theSession) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWIndexDefBadName", "Index names cannot be null or empty.");
        }
        if (isSystemIndex) {
            if (!VWFieldType.isValidName(theName, false)) {
                throw new VWException("vw.api.VWIndexDefinitionInvalidSystemIndexName", "Syntax error in system index name {0}, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name begining with F_, or be a language keyword such as ''if'').", theName, 128);
            }
        } else if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWIndexDefinitionInvalidIndexName", "Syntax error in index name {0}, it must begin with a letter, contain only letters, numbers or underscores, length <= {1} and cannot be a name reserved for FileNet internal use (like a name begining with F_, or be a language keyword such as ''if'').", theName, 128);
        }
        if (theFields == null || theFields[0] == null) {
            throw new VWException("vw.api.VWIndexDefFieldsAreNull", "Index fields cannot be null or empty.  The first field name must be a valid exposed field name.");
        }
        this.name = theName;
        this.tableDefinition = theTableDefinition;
        this.bHasChanged = true;
        this.setSession(theSession);
        if (internal) {
            this.internalSetFieldNames(theFields);
        } else {
            this.setFieldNames(theFields);
        }
        this.systemIndex = isSystemIndex;
        if (theName.startsWith("F_") && theName.compareTo("F_WorkFlowNumber") != 0) {
            this.mandatorySystemIndex = true;
        }
        this.bHasChanged = false;
    }

    public String[] getFieldNames() {
        return this.translateStrArray(this.getAuthoredFieldNames(false));
    }

    public String[] getAuthoredFieldNames() {
        return this.getAuthoredFieldNames(false);
    }

    protected String[] getAuthoredFieldNames(boolean includeInternal) {
        try {
            if (!includeInternal) {
                Object[] fNames = new String[this.fieldNames.length];
                System.arraycopy(this.fieldNames, 0, fNames, 0, this.fieldNames.length);
                VWArrayHandler fieldNamesHandler = new VWArrayHandler();
                fieldNamesHandler.setElementCount(fNames.length);
                if (this.tableDefinition != null && this.tableDefinition instanceof VWQueueDefinition) {
                    if (((String)fNames[fNames.length - 1]).equals("F_UniqueId")) {
                        fieldNamesHandler.deleteElementFromArray(fNames, fNames.length - 1);
                    }
                    VWQueueDefinition qDef = (VWQueueDefinition)this.tableDefinition;
                    if (fieldNamesHandler.getElementCount() > 0 && ((String)fNames[0]).equals("F_BoundUser") && qDef.getQueueType() == 2 && !qDef.getName().endsWith(")")) {
                        fieldNamesHandler.deleteElementFromArray(fNames, 0);
                    }
                }
                return (String[])fieldNamesHandler.getElements(fNames);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fieldNames;
    }

    public void setFieldNames(String[] theFieldNames) throws VWException {
        if (theFieldNames == null) {
            throw new VWException("vw.api.VWIndexDefIndexFieldsAreNull", "The Index fields are null. At least one field is required to create an index.");
        }
        for (int i = 0; i < theFieldNames.length; ++i) {
            if (!theFieldNames[i].equals("F_UniqueId")) continue;
            throw new VWException("vw.api.VWIndexDefIndexFUniqueIdReserved", "Field F_UniqueId is a reserved field name that is only valid on system indexes.");
        }
        this.internalSetFieldNames(theFieldNames);
    }

    protected void internalSetFieldNames(String[] theFieldNames) throws VWException {
        int i;
        boolean bFoundWobNum = false;
        boolean bFoundTimeStamp = false;
        boolean bFoundSeqNumber = false;
        if (this.systemIndex) {
            throw new VWException("vw.api.VWIndexCantChange", "System Indexes cannot be changed.");
        }
        int count = theFieldNames.length;
        if (this.tableDefinition != null && this.tableDefinition.theFieldsHandler != null && this.tableDefinition.theFieldDefs != null) {
            for (i = 0; i < count; ++i) {
                if (theFieldNames[i] == null) {
                    throw new VWException("vw.api.VWIndexDefIndexAFieldIsNull", "A field of the index is null.");
                }
                int theIndex = this.tableDefinition.theFieldsHandler.getIndexFromStringFieldValue(this.tableDefinition.theFieldDefs, "name", theFieldNames[i]);
                if (theIndex != -1) continue;
                throw new VWException("vw.api.VWIndexDefFieldNameNotFound", "Field name not found. Field names are case sensitive. Check spelling and case. {0}", theFieldNames[i]);
            }
        }
        for (i = 0; i < count; ++i) {
            if (!this.systemIndex && this.tableDefinition != null) {
                if (theFieldNames[i].compareTo("F_WobNum") == 0) {
                    bFoundWobNum = true;
                }
                if (theFieldNames[i].compareTo("F_TimeStamp") == 0) {
                    bFoundTimeStamp = true;
                }
                if (theFieldNames[i].compareTo("F_SeqNumber") == 0) {
                    bFoundSeqNumber = true;
                }
            }
            for (int j = i + 1; j < count; ++j) {
                if (theFieldNames[i].compareTo(theFieldNames[j]) != 0) continue;
                throw new VWException("vw.api.VWIndexFieldDefDupName", "{0} is a duplicate field name.", theFieldNames[i]);
            }
        }
        int numToAdd = 0;
        if (!this.systemIndex && this.tableDefinition != null) {
            boolean bNeedWobNum = false;
            boolean bNeedTimeStamp = false;
            boolean bNeedSeqNumber = false;
            if (!(this.tableDefinition instanceof VWQueueDefinition)) {
                if (this.tableDefinition instanceof VWRosterDefinition) {
                    if (!bFoundWobNum) {
                        ++numToAdd;
                        bNeedWobNum = true;
                    }
                } else if (this.tableDefinition instanceof VWLogDefinition) {
                    if (!bFoundTimeStamp) {
                        ++numToAdd;
                        bNeedTimeStamp = true;
                    }
                    if (!bFoundSeqNumber) {
                        ++numToAdd;
                        bNeedSeqNumber = true;
                    }
                }
            }
            String[] newArray = (String[])Array.newInstance(theFieldNames[0].getClass(), count + numToAdd);
            int arrayLoc = 0;
            for (arrayLoc = 0; arrayLoc < count; ++arrayLoc) {
                newArray[arrayLoc] = theFieldNames[arrayLoc];
            }
            if (bNeedWobNum) {
                newArray[arrayLoc++] = "F_WobNum";
            }
            if (bNeedTimeStamp) {
                newArray[arrayLoc++] = "F_TimeStamp";
            }
            if (bNeedSeqNumber) {
                newArray[arrayLoc++] = "F_SeqNumber";
            }
            theFieldNames = newArray;
        }
        this.fieldNames = theFieldNames;
        this.bHasChanged = true;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public String toString() {
        return this.getName();
    }

    public String getAuthoredName() throws VWException {
        return this.translateToAuthored(this.name);
    }

    public boolean isSystemIndex() {
        return this.systemIndex;
    }

    protected void setSystemIndex(boolean theValue) {
        this.systemIndex = theValue;
    }

    public boolean isMandatorySystemIndex() {
        return this.mandatorySystemIndex;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWDataFieldNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "IndexDefinition" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        theBuffer.append(INDENT_1 + "IsSystemIndex" + "=\"" + this.systemIndex + "\"\n");
        theBuffer.append(INDENT_1 + "IsMandatorySystemIndex" + "=\"" + this.mandatorySystemIndex + "\"");
        theBuffer.append(">\n");
        String[] fieldNameList = this.getFieldNames();
        theBuffer.append(INDENT_1 + "<" + "FieldNames" + ">\n");
        if (fieldNameList != null && fieldNameList.length > 0) {
            for (int i = 0; i < fieldNameList.length; ++i) {
                theBuffer.append(INDENT_2 + "<" + "Value" + ">" + VWXMLHandler.toXMLString(fieldNameList[i]) + "</Value>\n");
            }
        }
        theBuffer.append(INDENT_1 + "</" + "FieldNames" + ">\n");
        theBuffer.append(INDENT_0 + "</" + "IndexDefinition" + ">\n");
    }

    protected void setMandatorySystemIndex(boolean theValue) {
        this.mandatorySystemIndex = theValue;
        if (this.mandatorySystemIndex) {
            this.systemIndex = true;
        }
    }

    protected boolean hasChanged() {
        return this.bHasChanged;
    }

    protected void setHasChanged(boolean theNewValue) {
        this.bHasChanged = theNewValue;
    }

    protected boolean isIn(String theFieldName) {
        if (this.fieldNames != null) {
            int count = this.fieldNames.length;
            for (int loop = 0; loop < count; ++loop) {
                if (this.fieldNames[loop].compareTo(theFieldName) != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected VWTableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    protected void setTableDefinition(VWTableDefinition theTableDefinition) {
        this.tableDefinition = theTableDefinition;
    }

    protected Object clone() {
        try {
            VWIndexDefinition indexDef = (VWIndexDefinition)super.clone();
            return indexDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

